#include <bits/stdc++.h>

using namespace std;

enum EDirection {
	LeftDirection,
	RightDirection
};

long getMedian(long n, long numbers[]) {
	
	long middleIndex = (n / 2) - 1;
	
	float result;
	
	if (n % 2 == 0) {
		result = (numbers[middleIndex] + numbers[middleIndex+1]) / 2;
	} else {
		result = numbers[n/2];
	}
	
	return ceil(result);
}

long getNumberOfMoves(long n, long left[], long right[], long median, EDirection direction) {
	long sum = 0;
	
	for (long i = 0; i < n; i++) {
	
		if (direction == LeftDirection) {
			sum += abs(median - left[i]);
		} else {
			sum += abs(median - right[i]);
		}
	}
	
	return sum;
}

int main() {
	
	long n, m;
	scanf("%ld %ld", &n, &m);
	
	long left[n];
	long right[n];
	long positions[n][2];
	
	for (long i = 0; i < n; i++) {
		long l, r;
		
		scanf("%ld %ld", &l, &r);
		
		left[i] = l;
		right[i] = r;
	}
	
	sort(left, left+n);
	sort(right, right+n);
	
	long leftMedian = getMedian(n, left);
	long leftMedianResult = getNumberOfMoves(n, left, right, leftMedian, LeftDirection);
	
	long rightMedian = getMedian(n, right);
	long rightMedianResult = getNumberOfMoves(n, left, right, rightMedian, RightDirection);
	
	printf("%ld", min(leftMedianResult, rightMedianResult));
	
	return 0;
}